// Franzis - Programmieren mit KI - Bausatz - Niklas Heinzel - 2025
// 2_RGB-und-Taster-Skript
 
// Definition der Pins
const int redPin = 2;      // Pin D2 steuert die rote LED-Komponente
const int greenPin = 3;    // Pin D3 steuert die grüne LED-Komponente
const int bluePin = 4;     // Pin D4 steuert die blaue LED-Komponente
const int buttonPin = 5;   // Pin D5 erfasst den Taster-Eingang

int colorState = 0;        // Variable zum Speichern des aktuellen Farbzustands (0 = aus, 1 = rot, usw.)
bool buttonPressed = false; // Variable, um den Status des Tasters zu verfolgen (gedrückt/losgelassen)

void setup() {
  pinMode(redPin, OUTPUT);     // Pin D2 (Rot) als Ausgang konfigurieren
  pinMode(greenPin, OUTPUT);   // Pin D3 (Grün) als Ausgang konfigurieren
  pinMode(bluePin, OUTPUT);    // Pin D4 (Blau) als Ausgang konfigurieren
  pinMode(buttonPin, INPUT_PULLUP); // Pin D5 (Taster) als Eingang mit internem Pull-Up-Widerstand konfigurieren

  // LEDs initial ausschalten (bei gemeinsamer Anode: HIGH bedeutet aus)
  digitalWrite(redPin, HIGH);   // Rote LED ausschalten
  digitalWrite(greenPin, HIGH); // Grüne LED ausschalten
  digitalWrite(bluePin, HIGH);  // Blaue LED ausschalten
}

void loop() {
  // Prüfen, ob der Taster gedrückt ist (LOW bedeutet gedrückt wegen Pull-Up-Widerstand)
  if (digitalRead(buttonPin) == LOW && !buttonPressed) {
    buttonPressed = true;       // Tasterstatus setzen: Taster wurde gedrückt
    colorState = (colorState + 1) % 4; // Farbzustand erhöhen (0 -> 1 -> 2 -> 3 -> 0)
    delay(20);                  // Kurze Verzögerung zur Entprellung des Tasters
  } 
  else if (digitalRead(buttonPin) == HIGH && buttonPressed) {
    buttonPressed = false;      // Tasterstatus zurücksetzen: Taster wurde losgelassen
  }

  // Farbe basierend auf dem aktuellen Zustand setzen
  switch (colorState) {
    case 0: setRGB(HIGH, HIGH, HIGH); break;   // Zustand 0: Alle LEDs aus
    case 1: setRGB(LOW, HIGH, HIGH); break;   // Zustand 1: Nur rote LED an
    case 2: setRGB(HIGH, LOW, HIGH); break;   // Zustand 2: Nur grüne LED an
    case 3: setRGB(HIGH, HIGH, LOW); break;   // Zustand 3: Nur blaue LED an
  }
}

// Funktion, um die RGB-Pins basierend auf den übergebenen Werten zu steuern
void setRGB(int redValue, int greenValue, int blueValue) {
  digitalWrite(redPin, redValue);   // Rot: LOW = an, HIGH = aus (gemeinsame Anode)
  digitalWrite(greenPin, greenValue); // Grün: LOW = an, HIGH = aus (gemeinsame Anode)
  digitalWrite(bluePin, blueValue);  // Blau: LOW = an, HIGH = aus (gemeinsame Anode)
}
